//Dustin Soodak

//behavior 030: shot 21
//go forewared with pretty lights and turn 180 degrees



//
//In this example, Moody chirps and flashes her lights on reset.
//After either pressing the button or clicking on the IR remote, 
//turn on headlights & mood lighting, travel approximately 90cm,
//and turn 180 degrees.
//
//created Jan 28 2015 
//by Dustin Soodak
//for Bot Nugget LLC
//

#include "MiscHardware.h"
void setup(){
  HardwareBegin();//always call this first
  SwitchButtonToPixels();//since button and LEDs share pin
  PlayChirp(1000, 50);//frequency 1000hz, amplitude 50
  SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();//headlights green
  delay(100);
  PlayChirp(1000, 0);//amplitude 0 to turn off
  SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();//headlights off
}
int i;
void loop(){
  SwitchPixelsToButton();
  SwitchMotorsToSerial();//since serial port and motors share pins
  RestartTimer();//ultra-simple timer function using millis()  
  RxIRRestart();//start looking for IR pulses with 38khz receiver
  while(1){//
    if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);//print IR bytes received
      }
      if(IRBytes[2]==0x45 && IRBytes[3]==0xBA){//if power button pressed
        IRBytes[2]=0;IRBytes[3]=0;break;
      }
      else{
        RxIRRestart();SwitchPixelsToButton();
      }       
    }//end if(IsIRDone())
    if(ButtonPressed()){
      delay(1000);break; 
    }
  }//end while(1) wait for robot or IR button
  ZeroNavigation();//sets position to {0,0} and direction to 0 degrees
  SwitchButtonToPixels();
  SetPixelRGB(5,0,100,0);SetPixelRGB(6,0,100,0);//headlights/eyes green
  SetPixelRGB(2,100,0,100);SetPixelRGB(3,0,0,100);RefreshPixels();//purple and blue mood lighting (LEDs on bottom)
  MoveWithOptions(0, 150, 900, 5000, 500, 0, 0);//move at heading 0 degrees, motor speed 50, distance 900mm, timeout 5000ms
  RotateAccurate(180, 2000);//rotate to heading 180 degrees, timeout 2000ms
  SetAllPixelsRGB(0,0,0);RefreshPixels();//turn off all LEDs
  
}







